﻿#include  "StdAfx.h"
#include  "BitmapManager.hpp"
#include  "Render.hpp"

BitmapManager::BitmapManager() : m_Bitmaps()
{
}

BitmapManager::~BitmapManager()
{
	for (std::map<int, HBITMAP>::iterator it = m_Bitmaps.begin(); it != m_Bitmaps.end(); ++it)
		DeleteObject(it->second);
  m_Bitmaps.clear();
}

HBITMAP BitmapManager::IconToBitmapARGB(int nIconID)
{
  HBITMAP hBitmap = Retrieve(nIconID);
  if (hBitmap != 0)
    return hBitmap;

  hBitmap = Render::IconToBitmapPARGB32(nIconID);
  if (hBitmap != 0)
    Register(nIconID, hBitmap);

  return hBitmap;
}

HBITMAP BitmapManager::IconToBitmap(int nIconID)
{
  HBITMAP hBitmap = Retrieve(nIconID);
  if (hBitmap != 0)
    return hBitmap;

  hBitmap = Render::IconToBitmap(nIconID);
  if (hBitmap != 0)
    Register(nIconID, hBitmap);

  return hBitmap;
}

HBITMAP BitmapManager::Retrieve(int nIconID)
{
	std::map<int, HBITMAP>::iterator it = m_Bitmaps.lower_bound(nIconID);
	if (it != m_Bitmaps.end() && it->first == nIconID)
		return it->second;

  return 0;
}

void BitmapManager::Register(int nIconID, HBITMAP hBitmap)
{
  m_Bitmaps[nIconID] = hBitmap;
}
